<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*/

/** */
require_once APPPATH.'models/mailbox.php';

/**
* @package direct-as-a-service
* @subpackage models
*/
class UserSettingsModel extends CI_Model {
	
    function __construct() {
        parent::__construct();
		$this->load->database();
    }
	
	/*
	 * get a list of web services
	 */
	public function get_web_services(){
		return $this->db->query('SELECT * FROM web_services ORDER BY LOWER(name)');
	}
	
	public function save_application_web_service_access_by_setting_id($mailbox_setting_id, $authorized) {
		if($authorized === 'on') {
			return $query = $this->db->query('UPDATE mailbox_settings SET authorized = 1 WHERE id = '.$this->db->escape($mailbox_setting_id));
		}
		else {
			return $query = $this->db->query('UPDATE mailbox_settings SET authorized = 0 WHERE id = '.$this->db->escape($mailbox_setting_id));
		}
	}
	
	public function save_application_web_service_access($mailbox_id, $application_id, $web_service_id, $authorized) {
		if($authorized === 'on') {
			return $query = $this->db->query('UPDATE mailbox_settings SET authorized = 1 ' .
					' WHERE mailbox_id = '.$this->db->escape($mailbox_id) .
					' and application_id = ' . $this->db->escape($application_id) .
					' and web_service_id = ' . $this->db->escape($web_service_id));
		}
		else {
			return $query = $this->db->query('UPDATE mailbox_settings SET authorized = 0 ' .
					' WHERE mailbox_id = '.$this->db->escape($mailbox_id) .
					' and application_id = ' . $this->db->escape($application_id) .
					' and web_service_id = ' . $this->db->escape($web_service_id));
		}
	}
	
	public function save_mailbox_settings_entry($mailbox_id, $application_id, $web_service_id, $authorized) {
			
		$query = $this->db->query('SELECT * FROM mailbox_settings where mailbox_id = ' . $this->db->escape($mailbox_id) . ' and application_id = ' . $this->db->escape($application_id) . ' and web_service_id = ' . $this->db->escape($web_service_id))->result();
		if(empty($query)) {
			if($authorized === 'on') {
				return $this->db->query('INSERT INTO mailbox_settings (mailbox_id, application_id, web_service_id, authorized) VALUES(' . $this->db->escape($mailbox_id) . ',' . $this->db->escape($application_id) . ',' . $this->db->escape($web_service_id) . ',1)');
			}
			else {
				return $this->db->query('INSERT INTO mailbox_settings (mailbox_id, application_id, web_service_id, authorized) VALUES(' . $this->db->escape($mailbox_id) . ',' . $this->db->escape($application_id) . ',' . $this->db->escape($web_service_id) . ',0)');
			}
		}
		else {
			return $this->save_application_web_service_access($mailbox_id, $application_id, $web_service_id, $authorized);
		}
	
	}
	
	public function mailbox_settings_setup($mailbox_id, $application_id, $action) {
		$web_services = $this->get_web_services()->result();
		foreach($web_services as $web_service) {
			$query = $this->db->query('SELECT * FROM mailbox_settings where mailbox_id = ' . $this->db->escape($mailbox_id) . ' and application_id = ' . $this->db->escape($application_id) . ' and web_service_id = ' . $this->db->escape($web_service->id))->result();
			if($action == 'add') {
				if(empty($query)) {
					$this->db->query('INSERT INTO mailbox_settings (mailbox_id, application_id, web_service_id, authorized) VALUES(' . $this->db->escape($mailbox_id) . ',' . $this->db->escape($application_id) . ',' . $this->db->escape($web_service->id) . ',0)');
				}
			}
			else {
				if(!empty($query)) {
					$this->db->query('DELETE FROM mailbox_settings WHERE mailbox_id = ' . $this->db->escape($mailbox_id) . ' and application_id = ' . $this->db->escape($application_id) . ' and web_service_id = ' . $this->db->escape($web_service->id));
				}
			}
		}
	}
	
	public function delete_inapplicable_mailbox_settings($mailbox_id, $associated_app_id_or_name_array) {
		if(empty($associated_app_id_or_name_array)) {
			return $this->db->query('DELETE FROM mailbox_settings WHERE mailbox_id = ' . $this->db->escape($mailbox_id));
		}
		$app_ids_str = '';
		foreach($associated_app_id_or_name_array as $app_id_or_name) {
			$id;
			if(is_string($app_id_or_name)) {
				$id = $this->applicationmodel->get_application_id_by_name($app_id_or_name);
			}
			else {
				$id = $app_id_or_name;
			}
			$app_ids_str .= $this->db->escape($id) . ',';
		}
		$app_ids_str = replace_last_with(',', '', $app_ids_str);
		$app_ids_str = '(' . $app_ids_str . ')';
		
		if($mailbox_id && $app_ids_str) {
			return $this->db->query('DELETE FROM mailbox_settings WHERE mailbox_id = ' . $this->db->escape($mailbox_id) . ' and application_id NOT IN ' . $app_ids_str);
		}
		else {
			return FALSE;
		}
	}
	
	public function get_mailbox_id_by_name($name, $is_group) {
		$mailbox = Mailbox::find_one(compact('name', 'is_group'));
		if(!Mailbox::is_an_entity($mailbox)) return false;
		return $mailbox->id;
	}
	
	public function get_mailbox_settings_by_application($mailbox_id, $application_id) {
		return $query = $this->db->query('select ms.*, ws.name web_service_name, ws.description web_service_description ' .
				' from mailbox_settings ms, web_services ws ' .
				' where ms.web_service_id = ws.id ' .
				' and ms.mailbox_id = ' . $this->db->escape($mailbox_id) .
				' and ms.application_id = ' . $this->db->escape($application_id));
	}
	
	public function get_web_service_id_by_name($name) {
		$db = $this->load->database('default',TRUE);
		$query = $this->db->query('select id ' .
				' from web_services ' .
				' where name = ' . $this->db->escape($name))->result();
		if(!empty($query)) {
			return $query[0]->id;
		}
		else {
			return false;			
		}
	}
	
	public function is_app_authorized_for_web_service($mailbox_id, $application_id, $web_service_id) {
		$query = $this->db->query('select authorized ' .
				' from mailbox_settings ' .
				' where mailbox_id = ' . $this->db->escape($mailbox_id) .
				' and application_id = ' . $this->db->escape($application_id) .
				' and web_service_id = ' . $this->db->escape($web_service_id))->result();
	
		if(!isset($query[0])) {
			return false;
		}
		else {
			return $query[0]->authorized;
		}
	}
	
	/* This function updates a user's faciltiy information field in the given mailbox.
	 */
	public function update_facility_id_in_mailbox($name, $is_group, $facility_id) {
		$mailbox = Mailbox::find_one( compact('name', 'is_group') );
		if(!Mailbox::is_an_entity($mailbox)) { return false; }

		if(!empty($facility_id)){
			$mailbox->facility_id = $facility_id;
		}
		else {
			$mailbox->facility_id = null;
		}
		
		return $mailbox->save();
	}
	
	/* This function gets a user's faciltiy information in the given mailbox */
	public function get_facility_id_in_mailbox($name, $is_group) {
		$mailbox = Mailbox::find_one( compact('name', 'is_group') );
		if(!Mailbox::is_an_entity($mailbox)) return false;
		return $mailbox->facility_id;
	}
}
